/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.enricher;

import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.ParameterDslDeclarationEnricher;

public class ParameterDslDeclarationEnricherTestCase {
    private ParameterDslDeclarationEnricher enricher;
    private ExtensionLoadingContext extensionLoadingContext;
    private ExtensionDeclaration declaration;
    private ParameterGroupDeclaration parameterGroupDeclaration;
    private ObjectFieldType paramTypeField;

    @Before
    public void before() {
        this.enricher = new ParameterDslDeclarationEnricher();
        this.extensionLoadingContext = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        this.declaration = (ExtensionDeclaration)Mockito.mock(ExtensionDeclaration.class);
        this.parameterGroupDeclaration = (ParameterGroupDeclaration)Mockito.mock(ParameterGroupDeclaration.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)Mockito.mock(OperationDeclaration.class);
        Mockito.when((Object)operationDeclaration.getParameterGroups()).thenReturn(Collections.singletonList(this.parameterGroupDeclaration));
        Mockito.when((Object)this.declaration.getOperations()).thenReturn(Collections.singletonList(operationDeclaration));
        ExtensionDeclarer extensionDeclarer = (ExtensionDeclarer)Mockito.mock(ExtensionDeclarer.class);
        Mockito.when((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration())).thenReturn((Object)this.declaration);
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)extensionDeclarer);
        DslResolvingContext dslResolvingContext = (DslResolvingContext)Mockito.mock(DslResolvingContext.class);
        Mockito.when((Object)dslResolvingContext.getTypeCatalog()).thenReturn((Object)((TypeCatalog)Mockito.mock(TypeCatalog.class)));
        Mockito.when((Object)this.extensionLoadingContext.getDslResolvingContext()).thenReturn((Object)dslResolvingContext);
        this.paramTypeField = new ObjectFieldTypeBuilder(new MetadataFormat("label", "id", new String[0])).key("key").value((MetadataType)new ObjectTypeBuilder(new MetadataFormat("fieldLabel", "fieldKey", new String[0])).build()).build();
    }

    @Test
    public void sameAsNormalized() {
        HashMap<Class<ClassInformationAnnotation>, Object> typeAnnotations = new HashMap<Class<ClassInformationAnnotation>, Object>();
        typeAnnotations.put(TypeIdAnnotation.class, new TypeIdAnnotation("org.mule.test.SomeClass"));
        typeAnnotations.put(ParameterDslAnnotation.class, new ParameterDslAnnotation(false, false));
        typeAnnotations.put(ClassInformationAnnotation.class, new ClassInformationAnnotation("org.mule.test.SomeClass", true, false, true, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        DefaultObjectType type = new DefaultObjectType(Collections.singletonList(this.paramTypeField), true, null, null, typeAnnotations);
        ParameterDeclaration someParam = new ParameterDeclaration("someParam");
        someParam.setType((MetadataType)type, false);
        Mockito.when((Object)this.declaration.getTypes()).thenReturn(Collections.singleton(type));
        Mockito.when((Object)this.parameterGroupDeclaration.getParameters()).thenReturn(Collections.singletonList(someParam));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDslConfiguration dslConfiguration = someParam.getDslConfiguration();
        Assert.assertThat((Object)dslConfiguration.allowsInlineDefinition(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)dslConfiguration.allowsReferences(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)dslConfiguration.allowTopLevelDefinition(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void parameterSpecificAnnotation() {
        HashMap<Class<TypeIdAnnotation>, TypeIdAnnotation> typeAnnotations = new HashMap<Class<TypeIdAnnotation>, TypeIdAnnotation>();
        typeAnnotations.put(TypeIdAnnotation.class, new TypeIdAnnotation("org.mule.test.SomeClass"));
        DefaultObjectType extensionType = new DefaultObjectType(Collections.singletonList(this.paramTypeField), true, null, null, typeAnnotations);
        HashMap<Class<ClassInformationAnnotation>, Object> paramTypeAnnotations = new HashMap<Class<ClassInformationAnnotation>, Object>();
        paramTypeAnnotations.put(TypeIdAnnotation.class, new TypeIdAnnotation("org.mule.test.SomeClass"));
        paramTypeAnnotations.put(ParameterDslAnnotation.class, new ParameterDslAnnotation(false, false));
        paramTypeAnnotations.put(ClassInformationAnnotation.class, new ClassInformationAnnotation("org.mule.test.SomeClass", true, false, true, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        DefaultObjectType paramType = new DefaultObjectType(Collections.singletonList(this.paramTypeField), true, null, null, paramTypeAnnotations);
        ParameterDeclaration someParam = new ParameterDeclaration("someParam");
        someParam.setType((MetadataType)paramType, false);
        Mockito.when((Object)this.declaration.getTypes()).thenReturn(Collections.singleton(extensionType));
        Mockito.when((Object)this.parameterGroupDeclaration.getParameters()).thenReturn(Collections.singletonList(someParam));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDslConfiguration dslConfiguration = someParam.getDslConfiguration();
        Assert.assertThat((Object)dslConfiguration.allowsInlineDefinition(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)dslConfiguration.allowsReferences(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)dslConfiguration.allowTopLevelDefinition(), (Matcher)Matchers.is((Object)false));
    }
}

