/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.internal.loader.enricher.NamedObjectDeclarationEnricher;

@RunWith(value=MockitoJUnitRunner.class)
public class NamedObjectDeclarationEnricherTestCase {
    @Mock
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    private NamedObjectDeclarationEnricher enricher = new NamedObjectDeclarationEnricher();
    private ConfigurationDeclaration configurationDeclaration;

    @Before
    public void before() {
        this.configurationDeclaration = (ConfigurationDeclaration)((ConfigurationDeclarer)Mockito.spy((Object)new ExtensionDeclarer().withConfig("testConfiguration"))).getDeclaration();
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getConfigurations()).thenReturn(Collections.singletonList(this.configurationDeclaration));
    }

    @Test
    public void enrichedComponentModelHasNameParameter() {
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.configurationDeclaration.getAllParameters().iterator().next();
        Assert.assertThat((Object)parameterDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)parameterDeclaration.getModelProperty(SyntheticModelModelProperty.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void blocklistedConfigurationDoesntHaveNameParameter() {
        this.configurationDeclaration = (ConfigurationDeclaration)new ExtensionDeclarer().withConfig("wsSecurity").getDeclaration();
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getConfigurations()).thenReturn(Collections.singletonList(this.configurationDeclaration));
        Mockito.when((Object)this.extensionDeclaration.getName()).thenReturn((Object)"cxf");
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat((Object)this.configurationDeclaration.getAllParameters().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }
}

