/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.internal.loader.validator.ConfigurationModelValidator;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationModelValidatorTestCase {
    public static final String EXTENSION_NAME = "extension";
    public static final String CONFIG_NAME = "configName";
    public static final String OPERATION_NAME = "operation";
    public static final String PARAMETER_NAME = "parameterName";
    public static final String ALLOWLISTED_EXTENSION_NAME = "cxf";
    public static final String ALLOWLISTED_CONFIGURATION_NAME = "wsSecurity";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel parameterModel;
    @Mock(lenient=true)
    private ParameterModel nameParameterModel;
    private ExtensionModelValidator validator = new ConfigurationModelValidator();
    private ProblemsReporter problemsReporter;

    @Before
    public void before() {
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)CONFIG_NAME);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)this.parameterModel.isOverrideFromConfig()).thenReturn((Object)false);
        Mockito.when((Object)this.nameParameterModel.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.nameParameterModel.isOverrideFromConfig()).thenReturn((Object)false);
        Mockito.when((Object)this.nameParameterModel.getModelProperty(SyntheticModelModelProperty.class)).thenReturn(Optional.of(new SyntheticModelModelProperty()));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        ArrayList<ParameterModel> configurationParameters = new ArrayList<ParameterModel>();
        configurationParameters.add(this.parameterModel);
        configurationParameters.add(this.nameParameterModel);
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(configurationParameters);
    }

    @Test
    public void validConfiguration() {
        this.validate();
    }

    @Test
    public void configurationWithConfigOverrideParameter() {
        Mockito.when((Object)this.parameterModel.isOverrideFromConfig()).thenReturn((Object)true);
        this.validateError("Configuration 'configName' declares the parameters [parameterName] as '" + ConfigOverride.class.getSimpleName() + "', which is not allowed for this component parameters");
    }

    @Test
    public void configurationWithNonSyntheticNameParameter() {
        Mockito.when((Object)this.nameParameterModel.getModelProperty(SyntheticModelModelProperty.class)).thenReturn(Optional.empty());
        this.validateError("Configuration 'configName' declares a parameter whose name is 'name', which is not allowed");
    }

    @Test
    public void configurationWithNonSyntheticNameParameterFromAllowList() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)ALLOWLISTED_EXTENSION_NAME);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)ALLOWLISTED_CONFIGURATION_NAME);
        Mockito.when((Object)this.nameParameterModel.getModelProperty(SyntheticModelModelProperty.class)).thenReturn(Optional.empty());
        this.validate();
    }

    private void validate() {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void validateError(String errorMessage) {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)this.problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.containsString((String)errorMessage));
    }
}

