/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.AbstractComplexModel;

public class ImmutableConfigurationModel
extends AbstractComplexModel
implements ConfigurationModel {
    private final StereotypeModel stereotype;
    private final List<ParameterGroupModel> parameterGroupModels;
    private final Set<ExternalLibraryModel> externalLibraryModels;
    private final MuleVersion minMuleVersion;

    public ImmutableConfigurationModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, operationModels, connectionProviders, sourceModels, externalLibraryModels, displayModel, stereotype, modelProperties, null);
    }

    public ImmutableConfigurationModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, operationModels, connectionProviders, sourceModels, externalLibraryModels, displayModel, stereotype, modelProperties, deprecationModel, null);
    }

    public ImmutableConfigurationModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, Set<ExternalLibraryModel> externalLibraryModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, MuleVersion minMuleVersion) {
        super(name, description, operationModels, connectionProviders, sourceModels, displayModel, modelProperties, deprecationModel);
        this.parameterGroupModels = Collections.unmodifiableList(new ArrayList<ParameterGroupModel>(parameterGroupModels));
        this.externalLibraryModels = Collections.unmodifiableSet(externalLibraryModels);
        this.stereotype = stereotype;
        this.minMuleVersion = minMuleVersion;
    }

    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraryModels;
    }

    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    @Override
    public String toString() {
        return "ImmutableConfigurationModel{stereotype=" + this.stereotype + ", parameterGroupModels=" + this.parameterGroupModels + ", externalLibraryModels=" + this.externalLibraryModels + ", minMuleVersion=" + this.minMuleVersion + "} " + super.toString();
    }
}

