/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.dsl;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.test.dsl.BaseXmlDeclarationTestCase;

public class ListOfRoutesXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    public ListOfRoutesXmlDeclarationTestCase() {
        super(ParameterRole.BEHAVIOUR);
    }

    @Test
    public void visitNestedRoute() {
        OperationModel routerModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)routerModel.getName()).thenReturn((Object)"listOfRoutesRouter");
        NestableElementModel nestable = (NestableElementModel)Mockito.mock(NestableElementModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{NestedRouteModel.class}));
        Mockito.when((Object)nestable.getName()).thenReturn((Object)"listOfRoutes");
        Mockito.when((Object)nestable.getMaxOccurs()).thenReturn(Optional.empty());
        ((NestableElementModel)Mockito.doAnswer(inv -> {
            ((ComponentModelVisitor)inv.getArgument(0, ComponentModelVisitor.class)).visit((NestedRouteModel)inv.getMock());
            return null;
        }).when((Object)nestable)).accept((ComponentModelVisitor)ArgumentMatchers.any(ComponentModelVisitor.class));
        ((OperationModel)Mockito.doReturn(Collections.singletonList(nestable)).when((Object)routerModel)).getNestedComponents();
        ((OperationModel)Mockito.doAnswer(inv -> {
            ((ComponentModelVisitor)inv.getArgument(0, ComponentModelVisitor.class)).visit((OperationModel)inv.getMock());
            return null;
        }).when((Object)routerModel)).accept((ComponentModelVisitor)ArgumentMatchers.any(ComponentModelVisitor.class));
        DslElementSyntax dslElementSyntax = this.getSyntaxResolver().resolve((NamedObject)routerModel);
        Optional listOfRoutes = dslElementSyntax.getChild("listOfRoutes");
        MatcherAssert.assertThat((Object)listOfRoutes.isPresent(), (Matcher)Matchers.is((Object)true));
        Optional listOfRoute = ((DslElementSyntax)listOfRoutes.get()).getChild("listOfRoute");
        MatcherAssert.assertThat((Object)listOfRoute.isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

