/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.soap.metadata;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.util.Reference;

public class SoapOutputTypeBuilder {
    public static final String BODY_FIELD = "body";
    public static final String HEADERS_FIELD = "headers";
    public static final String ATTACHMENTS_FIELD = "attachments";

    public static MetadataType buildOutputType(final MetadataType body, MetadataType attachments, final BaseTypeBuilder builder) {
        final Reference result = new Reference();
        attachments.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                ObjectTypeBuilder object = builder.objectType();
                object.addField().key(SoapOutputTypeBuilder.BODY_FIELD).value(body);
                object.addField().key(SoapOutputTypeBuilder.ATTACHMENTS_FIELD).value().arrayType().of((TypeBuilder)builder.anyType());
                result.set((Object)object.build());
            }

            public void visitNull(NullType nullType) {
                result.set((Object)body);
            }
        });
        return (MetadataType)result.get();
    }

    public static MetadataType buildOutputAttributesType(MetadataType soapHeaders, BaseTypeBuilder builder) {
        ObjectTypeBuilder attributes = builder.objectType();
        attributes.addField().key(HEADERS_FIELD).value(soapHeaders);
        ObjectTypeBuilder protocolHeaders = attributes.addField().key("protocolHeaders").value().objectType();
        protocolHeaders.openWith().stringType();
        return attributes.build();
    }
}

