/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.soap.security;

import org.mule.runtime.extension.api.soap.security.PasswordType;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;
import org.mule.runtime.extension.api.soap.security.SecurityStrategyVisitor;

public final class UsernameTokenSecurityStrategy
implements SecurityStrategy {
    private final String username;
    private final String password;
    private final PasswordType passwordType;
    private final boolean addNonce;
    private final boolean addCreated;

    public UsernameTokenSecurityStrategy(String username, String password, PasswordType passwordType, boolean addNonce, boolean addCreated) {
        this.username = username;
        this.password = password;
        this.passwordType = passwordType;
        this.addNonce = addNonce;
        this.addCreated = addCreated;
    }

    public UsernameTokenSecurityStrategy(String username, String password, PasswordType passwordType) {
        this.username = username;
        this.password = password;
        this.passwordType = passwordType;
        this.addCreated = false;
        this.addNonce = false;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public PasswordType getPasswordType() {
        return this.passwordType;
    }

    public boolean isAddNonce() {
        return this.addNonce;
    }

    public boolean isAddCreated() {
        return this.addCreated;
    }

    @Override
    public void accept(SecurityStrategyVisitor visitor) {
        visitor.visitUsernameToken(this);
    }
}

