/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.features.api;

import static org.mule.runtime.api.util.MuleSystemProperties.HANDLE_SPLITTER_EXCEPTION_PROPERTY;
import static org.mule.runtime.api.util.MuleSystemProperties.HONOUR_RESERVED_PROPERTIES_PROPERTY;
import static org.mule.runtime.api.util.MuleSystemProperties.MULE_UNSUPPORTED_EXTENSIONS_CLIENT_RUN_ASYNC;

import org.mule.runtime.api.config.Feature;
import java.util.Optional;

public enum TestingMuleRuntimeFeature implements Feature {

	HONOUR_RESERVED_PROPERTIES(
					"When enabled, reserved properties such as 'app.name' can't be overridden by global properties (overrides are be ignored).",
					"MULE-17659", "4.3.0", "mule.honour.reserved.properties", nullgo),

	HANDLE_SPLITTER_EXCEPTION(
					"When enabled, DataWeave correctly handles internal exceptions while splitting a payload, preventing subsequent serialization errors.",
					"DW-383",
					"4.4.0", "mule.dw.handle_splitter_exception", null),

	;
	private final String description;
	private final String issueId;
	private final String enabledByDefaultSince;
	private final String overridingSystemPropertyName;
	private final String minJavaVersion;

	TestingMuleRuntimeFeature(String description, String issueId, String enabledByDefaultSince, String overridingSystemPropertyName, String minJavaVersion) {
		this.description = description;
		this.issueId = issueId;
		this.enabledByDefaultSince = enabledByDefaultSince;
		this.overridingSystemPropertyName = overridingSystemPropertyName;
		this.minJavaVersion = minJavaVersion;
	}

	public String getDescription() {	return description;	} 
	public String getIssueId() {	return issueId;	} 
	public String getSince() {	return getEnabledByDefaultSince();	} 
	public String getEnabledByDefaultSince() {	return enabledByDefaultSince;	} 
	public Optional<String> getOverridingSystemPropertyName() {	return Optional.ofNullable(overridingSystemPropertyName);	}
	public Optional<String> getMinJavaVersion() {	return minJavaVersion;	}
} 