/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.proxy;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.proxy.AbstractProxyConfigTestCase;
import org.mule.runtime.http.api.client.proxy.NtlmProxyConfigBuilder;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

@Feature(value="HTTP Service")
@Story(value="Proxy Config Builder")
public class NtlmProxyConfigBuilderTest
extends AbstractProxyConfigTestCase<NtlmProxyConfigBuilder> {
    private static final String NTLM_DOMAIN = "DOMAIN";
    private NtlmProxyConfigBuilder ntlmProxyConfigBuilder = (NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)ProxyConfig.NtlmProxyConfig.builder().username("user")).password("pass");

    @Override
    protected NtlmProxyConfigBuilder getProxyConfigBuilder() {
        return this.ntlmProxyConfigBuilder;
    }

    @Test
    void onlyDomain() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.ntlmProxyConfigBuilder.ntlmDomain(NTLM_DOMAIN).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Host must be not null"));
    }

    @Test
    void fullConfig() {
        ProxyConfig.NtlmProxyConfig config = ((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)((NtlmProxyConfigBuilder)this.ntlmProxyConfigBuilder.host("host")).port(8080)).ntlmDomain(NTLM_DOMAIN).username("username")).password("password")).nonProxyHosts("host1,host2")).build();
        MatcherAssert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)"host"));
        MatcherAssert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        MatcherAssert.assertThat((Object)config.getNtlmDomain(), (Matcher)Is.is((Object)NTLM_DOMAIN));
        MatcherAssert.assertThat((Object)config.getPassword(), (Matcher)Is.is((Object)"password"));
        MatcherAssert.assertThat((Object)config.getUsername(), (Matcher)Is.is((Object)"username"));
        MatcherAssert.assertThat((Object)config.getNonProxyHosts(), (Matcher)Is.is((Object)"host1,host2"));
    }
}

