/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.client.proxy;

import org.mule.api.annotation.NoImplement;

/**
 * Allows specifying a prebuilt {@link ProxyConfig} to which the HTTP client will delegate proxy handling. This uses the provided
 * configuration as-is, bypassing standard SDK conversion.
 *
 * @since 4.10.0
 */
@NoImplement
public interface DelegatingProxyConfigurer {

  /**
   * Specifies the {@link ProxyConfig} to which proxy handling will be delegated.
   *
   * @param proxyConfig the configuration to use as the delegate
   * @return this configurer
   */
  DelegatingProxyConfigurer delegateConfig(ProxyConfig proxyConfig);
}
