/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.proxy;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.proxy.AbstractProxyConfigTestCase;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;

@Feature(value="HTTP Service")
@Story(value="Proxy Config Builder")
public class ProxyConfigBuilderTest
extends AbstractProxyConfigTestCase<ProxyConfigBuilder> {
    private ProxyConfigBuilder proxyConfigBuilder = ProxyConfig.builder();

    @Override
    protected ProxyConfigBuilder getProxyConfigBuilder() {
        return this.proxyConfigBuilder;
    }

    @Test
    void minimalConfig() {
        ProxyConfig config = ((ProxyConfigBuilder)((ProxyConfigBuilder)this.proxyConfigBuilder.host("host")).port(8080)).build();
        MatcherAssert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)"host"));
        MatcherAssert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        MatcherAssert.assertThat((Object)config.getPassword(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)config.getUsername(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)config.getAuthHeaderFactory(), (Matcher)IsNull.nullValue());
    }

    @Test
    void fullConfig() {
        ProxyConfig config = ((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)((ProxyConfigBuilder)this.proxyConfigBuilder.host("host")).port(8080)).username("username")).password("password")).nonProxyHosts("host1,host2")).build();
        MatcherAssert.assertThat((Object)config.getHost(), (Matcher)Is.is((Object)"host"));
        MatcherAssert.assertThat((Object)config.getPort(), (Matcher)Is.is((Object)8080));
        MatcherAssert.assertThat((Object)config.getPassword(), (Matcher)Is.is((Object)"password"));
        MatcherAssert.assertThat((Object)config.getUsername(), (Matcher)Is.is((Object)"username"));
        MatcherAssert.assertThat((Object)config.getNonProxyHosts(), (Matcher)Is.is((Object)"host1,host2"));
    }
}

