/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.domain.entity.DefaultEntityFactory;
import org.mule.runtime.http.api.domain.entity.EntityFactory;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry.RequestMatcherRegistryBuilder;
import org.mule.runtime.http.api.ws.WebSocketBroadcaster;

/**
 * Provides HTTP server and client factories.
 *
 * @since 4.0
 */
@NoImplement
public interface HttpService extends Service {

  /**
   * @return an {@link HttpServerFactory} capable of creating {@link HttpServer}s.
   */
  HttpServerFactory getServerFactory();

  /**
   * @return an {@link HttpClientFactory} capable of creating {@link HttpClient}s.
   */
  HttpClientFactory getClientFactory();

  /**
   * @return a fresh builder of {@link RequestMatcherRegistry RequestMatcherRegistries}.
   * @since 4.1.5
   */
  RequestMatcherRegistryBuilder getRequestMatcherRegistryBuilder();

  /**
   * Returns a new {@link WebSocketBroadcaster}. Instances are not be assumed reusable. Unless specific implementation says
   * otherwise, create a new broadcaster per each message to be broadcasted.
   *
   * @return A new {@link WebSocketBroadcaster}
   * @since 4.2.0
   */
  default WebSocketBroadcaster newWebSocketBroadcaster() {
    throw new UnsupportedOperationException("WebSockets are only supported in Enterprise Edition");
  }

  /**
   * Gets a factory of {@link HttpEntity}s apart from the ones provided in the package
   * {@link org.mule.runtime.http.api.domain.entity}. It allows service implementers to provide their own entity implementations.
   *
   * @return a factory of {@link HttpEntity}.
   */
  default EntityFactory getEntityFactory() {
    return new DefaultEntityFactory();
  }
}
