/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.domain.entity;

import static java.util.Objects.requireNonNull;
import static java.util.Optional.of;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.OptionalLong;

/**
 * Represents a byte array HTTP body.
 *
 * @since 4.0
 */
public final class ByteArrayHttpEntity implements HttpEntity {

  private final byte[] content;

  public ByteArrayHttpEntity(byte[] content) {
    requireNonNull(content, "HTTP entity content cannot be null.");
    this.content = content;
  }

  @Override
  public boolean isStreaming() {
    return false;
  }

  @Override
  public InputStream getContent() {
    return new ByteArrayInputStream(content);
  }

  @Override
  public byte[] getBytes() {
    return this.content;
  }

  @Override
  public Optional<Long> getLength() {
    return of((long) content.length);
  }

  @Override
  public OptionalLong getBytesLength() {
    return OptionalLong.of(content.length);
  }


}
