/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client;

import java.util.concurrent.CompletableFuture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ManagedLifecycleHttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class ManagedLifecycleHttpClientTestCase {
    @Mock
    private HttpRequest request;
    @Mock
    private HttpRequestOptions options;
    @Mock
    private HttpResponse httpResponse;
    @Mock
    private HttpClient httpClient;
    private ManagedLifecycleHttpClient decorator;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.httpClient.sendAsync(this.request, this.options)).thenReturn(CompletableFuture.completedFuture(this.httpResponse));
        Mockito.when((Object)this.httpClient.send(this.request, this.options)).thenReturn((Object)this.httpResponse);
        this.decorator = new ManagedLifecycleHttpClient(this.httpClient);
    }

    @After
    public void after() {
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).start();
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void start() {
        this.decorator.start();
    }

    @Test
    public void stop() {
        this.decorator.stop();
    }

    @Test
    public void sendAsync() throws Exception {
        CompletableFuture f = this.decorator.sendAsync(this.request, this.options);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).sendAsync(this.request, this.options);
        Assert.assertThat((Object)((HttpResponse)f.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
    }

    @Test
    public void send() throws Exception {
        HttpResponse response = this.decorator.send(this.request, this.options);
        ((HttpClient)Mockito.verify((Object)this.httpClient)).send(this.request, this.options);
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.httpResponse)));
    }
}

