/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import io.qameta.allure.Feature;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;

@Feature(value="HTTP Service")
public class MethodRequestMatcherTestCase {
    @Test
    void cannotBeEmpty() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> MethodRequestMatcher.builder().build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"methods attribute should not be empty"));
    }

    @Test
    void cannotBeEmptyCollection() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> MethodRequestMatcher.builder(new LinkedList()).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"methods attribute should not be empty"));
    }

    @Test
    void cannotBeNullCollection() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> MethodRequestMatcher.builder(null).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"methods attribute should not be null"));
    }

    @Test
    void cannotBeNullString() {
        String none = null;
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> MethodRequestMatcher.builder().add(none));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"method attribute should not be null"));
    }

    @Test
    void cannotBeNullMethod() {
        HttpConstants.Method none = null;
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> MethodRequestMatcher.builder().add(none));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"method attribute should not be null"));
    }

    @Test
    void onlyAcceptsOneMethod() {
        MethodRequestMatcher matcher = MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build();
        HttpRequest getRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)getRequest.getMethod()).thenReturn((Object)HttpConstants.Method.GET.name());
        MatcherAssert.assertThat((Object)matcher.matches(getRequest), (Matcher)Is.is((Object)true));
        HttpRequest postRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)postRequest.getMethod()).thenReturn((Object)HttpConstants.Method.POST.name());
        MatcherAssert.assertThat((Object)matcher.matches(postRequest), (Matcher)Is.is((Object)false));
    }

    @Test
    void acceptSeveralMethods() {
        MethodRequestMatcher matcher = MethodRequestMatcher.builder().add(HttpConstants.Method.GET).add(HttpConstants.Method.POST).add(HttpConstants.Method.PATCH).build();
        HttpRequest getRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)getRequest.getMethod()).thenReturn((Object)HttpConstants.Method.GET.name());
        MatcherAssert.assertThat((Object)matcher.matches(getRequest), (Matcher)Is.is((Object)true));
        HttpRequest posrRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)posrRequest.getMethod()).thenReturn((Object)HttpConstants.Method.POST.name());
        MatcherAssert.assertThat((Object)matcher.matches(posrRequest), (Matcher)Is.is((Object)true));
        HttpRequest patchRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)patchRequest.getMethod()).thenReturn((Object)HttpConstants.Method.PATCH.name());
        MatcherAssert.assertThat((Object)matcher.matches(patchRequest), (Matcher)Is.is((Object)true));
        HttpRequest optionsRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)optionsRequest.getMethod()).thenReturn((Object)HttpConstants.Method.OPTIONS.name());
        MatcherAssert.assertThat((Object)matcher.matches(optionsRequest), (Matcher)Is.is((Object)false));
    }
}

