/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.proxy;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.proxy.BaseProxyConfigBuilder;

public abstract class AbstractProxyConfigTestCase<B extends BaseProxyConfigBuilder> {
    protected static final String HOST = "host";
    protected static final int PORT = 8080;
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String NON_PROXY_HOSTS = "host1,host2";

    protected abstract B getProxyConfigBuilder();

    @Test
    void onlyHost() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.getProxyConfigBuilder().host(HOST).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Port must be under 65535. Check that you set the port."));
    }

    @Test
    void onlyPort() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.getProxyConfigBuilder().port(8080).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"Host must be not null"));
    }
}

