/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message;


import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BasicTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

/**
 * Builder for The {@link MessageMetadataType}
 */
public class MessageMetadataTypeBuilder extends AbstractBuilder<MessageMetadataType>
    implements WithAnnotation<MessageMetadataTypeBuilder> {

  private Optional<TypeBuilder<? extends MetadataType>> payloadType;
  private Optional<TypeBuilder<? extends MetadataType>> attributesType;

  public MessageMetadataTypeBuilder() {
    super(MetadataFormat.JAVA);
    addExtension(new TypeIdAnnotation("org.mule.runtime.api.message.Message"));
    this.payloadType = Optional.empty();
    this.attributesType = Optional.empty();
  }


  public BaseTypeBuilder payload() {
    BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
    this.payloadType = Optional.of(baseTypeBuilder);
    return baseTypeBuilder;
  }

  public MessageMetadataTypeBuilder payload(MetadataType payloadType) {
    this.payloadType = Optional.of(new BasicTypeBuilder<>(payloadType));
    return this;
  }

  public BaseTypeBuilder attributes() {
    BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
    this.attributesType = Optional.of(baseTypeBuilder);
    return baseTypeBuilder;
  }

  public MessageMetadataTypeBuilder attributes(MetadataType payloadType) {
    this.attributesType = Optional.of(new BasicTypeBuilder<>(payloadType));
    return this;
  }

  @Override
  public MessageMetadataType build() {
    return new DefaultMessageMetadataType(payloadType.map(b -> b.build()), attributesType.map(b -> b.build()), annotations);
  }

  @Override
  public MessageMetadataTypeBuilder with(TypeAnnotation typeAnnotation) {
    this.addExtension(typeAnnotation);
    return this;
  }
}
