/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.api;


import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/**
 * Builder for the {@link MuleEventMetadataType}
 */
public class MuleEventMetadataTypeBuilder extends AbstractBuilder<MuleEventMetadataType>
    implements WithAnnotation<MuleEventMetadataTypeBuilder> {

  private MessageMetadataType messageMetadataType;
  private MessageMetadataTypeBuilder messageTypeBuilder;
  private ObjectTypeBuilder variables;

  public MuleEventMetadataTypeBuilder() {
    super(MetadataFormat.JAVA);
    this.messageTypeBuilder = new MessageMetadataTypeBuilder();
    this.variables = new ObjectTypeBuilder(MetadataFormat.JAVA);
  }

  public MessageMetadataTypeBuilder message() {
    return messageTypeBuilder;
  }

  public MuleEventMetadataTypeBuilder message(MessageMetadataTypeBuilder messageTypeBuilder) {
    this.messageTypeBuilder = messageTypeBuilder;
    return this;
  }

  public MuleEventMetadataTypeBuilder message(MessageMetadataType messageMetadataType) {
    this.messageMetadataType = messageMetadataType;
    return this;
  }

  public BaseTypeBuilder addVariable(String name) {
    return addVariableField(name).value();
  }

  public MuleEventMetadataTypeBuilder addVariable(String name, MetadataType metadataType) {
    addVariableField(name).value(metadataType);
    return this;
  }

  private ObjectFieldTypeBuilder addVariableField(String name) {
    return variables.addField().required(true).key(name);
  }

  @Override
  public MuleEventMetadataType build() {
    return new DefaultMuleEventMetadataType(messageMetadataType != null ? messageMetadataType : messageTypeBuilder.build(),
                                            variables.build(), annotations);
  }

  public MuleEventMetadataTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }
}
