/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.api.el;


import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * The identifier of a module
 */
public class ModuleIdentifier {

  public static final String NAME_SEPARATOR = "::";
  private String[] elements;

  public ModuleIdentifier(String... elements) {
    this.elements = elements;
  }

  public String[] getElements() {
    return elements;
  }

  @Override
  public String toString() {
    return Arrays.stream(elements).collect(Collectors.joining(NAME_SEPARATOR));
  }

  public static ModuleIdentifier fromString(String name) {
    return new ModuleIdentifier(name.split(NAME_SEPARATOR));
  }
}
