/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.api;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;

import java.util.Optional;

/**
 * Models a Mule Event MetadataType
 *
 * @since 1.0
 */
public interface MuleEventMetadataType extends ObjectType {

  /**
   * Creates a builder for the MuleEventMetadataType
   *
   * @return The builder
   */
  static MuleEventMetadataTypeBuilder builder() {
    return new MuleEventMetadataTypeBuilder();
  }


  /**
   * Creates a builder for the MuleEventMetadataType based on the specified event
   *
   * @param eventType The event to build builder from.
   * @return The builder
   */
  static MuleEventMetadataTypeBuilder builder(ObjectType eventType) {
    return MuleEventMetadataTypeBuilder.fromObjectType(eventType);
  }

  /**
   * The message metadata type
   *
   * @return The message type
   */
  MessageMetadataType getMessageType();

  /**
   * The error metadata type
   *
   * @return The error type
   */
  Optional<MetadataType> getErrorType();

  /**
   * An object with all the variables types.
   *
   * @return The types
   */
  ObjectType getVariables();

  /**
   * Returns the metadata type of a given variable
   *
   * @param varName The variable name
   * @return The metadata type if present.
   */
  Optional<MetadataType> getVariableType(String varName);

}
