/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.api.el;


import org.mule.metadata.api.model.MetadataType;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ModuleDefinition {

  private ModuleIdentifier name;
  private Map<String, MetadataType> declaredElements;

  public ModuleDefinition(ModuleIdentifier name, Map<String, MetadataType> declaredElements) {
    this.name = name;
    this.declaredElements = declaredElements;
  }

  public ModuleIdentifier getName() {
    return name;
  }

  public Collection<String> identifiers() {
    return declaredElements.keySet();
  }

  public Optional<MetadataType> lookup(String identifier) {
    return Optional.ofNullable(declaredElements.get(identifier));
  }

  public static Builder builder(String name) {
    return new Builder(name);
  }

  public static class Builder {

    private String name;
    private Map<String, MetadataType> declaredElements;

    public Builder(String name) {
      this.name = name;
      declaredElements = new HashMap<>();
    }

    public Builder addElement(String name, MetadataType type) {
      declaredElements.put(name, type);
      return this;
    }

    public ModuleDefinition build() {
      return new ModuleDefinition(ModuleIdentifier.fromString(name), declaredElements);
    }
  }
}
