/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api.el;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleIdentifier;

public class ModuleDefinition {
    private ModuleIdentifier name;
    private Map<String, MetadataType> declaredElements;

    public ModuleDefinition(ModuleIdentifier name, Map<String, MetadataType> declaredElements) {
        this.name = name;
        this.declaredElements = declaredElements;
    }

    public ModuleIdentifier getName() {
        return this.name;
    }

    public Collection<String> identifiers() {
        return this.declaredElements.keySet();
    }

    public Optional<MetadataType> lookup(String identifier) {
        return Optional.ofNullable(this.declaredElements.get(identifier));
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String name;
        private Map<String, MetadataType> declaredElements;

        public Builder(String name) {
            this.name = name;
            this.declaredElements = new HashMap<String, MetadataType>();
        }

        public Builder addElement(String name, MetadataType type) {
            this.declaredElements.put(name, type);
            return this;
        }

        public ModuleDefinition build() {
            return new ModuleDefinition(ModuleIdentifier.fromString(this.name), this.declaredElements);
        }
    }
}

