/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.api;

import org.mule.metadata.api.annotation.TypeAnnotation;

/**
 * Adds a location to the annotated type.
 */
public class LocationAnnotation implements TypeAnnotation {

  public static final String NAME = "location";
  private final String location;

  public LocationAnnotation(String location) {
    this.location = location;
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    LocationAnnotation that = (LocationAnnotation) o;

    return location.equals(that.location);

  }

  @Override
  public int hashCode() {
    return location.hashCode();
  }
}
