/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static org.mule.metadata.api.utils.MetadataTypeUtils.getTypeId;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class DefaultObjectType extends BaseMetadataType implements ObjectType {

  private Collection<ObjectFieldType> fields;
  private boolean ordered;

  private MetadataType openRestriction;

  public DefaultObjectType(Collection<ObjectFieldType> fields, boolean ordered, MetadataType openRestriction,
                           MetadataFormat metadataFormat,
                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.fields = fields;
    this.ordered = ordered;
    this.openRestriction = openRestriction;
  }

  @Override
  public boolean isOrdered() {
    return ordered;
  }

  @Override
  public Optional<MetadataType> getOpenRestriction() {
    return Optional.ofNullable(openRestriction);
  }

  @Override
  public Collection<ObjectFieldType> getFields() {
    return fields;
  }

  @Override
  public Optional<ObjectFieldType> getFieldByName(String propertyName) {
    return fields.stream()
        .filter(propertyType -> {
          final ObjectKeyType key = propertyType.getKey();
          return key.isName() && key.getName().getLocalPart().equals(propertyName);
        }).findFirst();
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitObject(this);
  }

  @Override
  public String toString() {
    return getTypeId(this).orElseGet(() -> super.toString());
  }
}
