/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import java.util.List;
import java.util.Optional;

/**
 * A function with arguments and a return type
 */
public interface FunctionType extends MetadataType {

  /**
   * Returns the list of parameters expected by this function
   *
   * @return The parameters
   */
  List<FunctionParameter> getParameters();

  /**
   * The return type of the function.
   * If the function does not return a value it returns empty.
   *
   * @return The return type of the function.
   */
  Optional<MetadataType> getReturnType();

}
