/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

/**
 * Represents a function parameter with a name and a Type
 */
public class FunctionParameter {

  private String name;
  private MetadataType type;

  public FunctionParameter(String name, MetadataType type) {
    this.name = name;
    this.type = type;
  }

  /**
   * Returns the name of the parameter
   *
   * @return The name
   */
  public String getName() {
    return name;
  }

  /**
   * Returns the type of the parameter
   *
   * @return The type of the parameter
   */
  public MetadataType getType() {
    return type;
  }

}
