/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import java.util.Collection;
import java.util.Optional;

/**
 * An object type represents a list of fields that is represented by key value
 * pairs type.
 */
public interface ObjectType extends MetadataType {

  /**
   * If this object allows additional properties that are not being described in the list of fields.
   * @return True if open
   */
  default boolean isOpen() {
    return getOpenRestriction().isPresent();
  }

  /**
   * Returns the restriction if any specified for the open type. This restriction applies to the type of the object's fields.
   * 
   * @return The restriction if any
   */
  Optional<MetadataType> getOpenRestriction();

  /**
   * The collection of all the fields
   *
   * @return The object fields
   */
  Collection<ObjectFieldType> getFields();

  /**
   * If the list of fields must respect the order or not
   *
   * @return True if they must be ordered
   */
  boolean isOrdered();

  /**
   * Searches a field that matches the specified name
   *
   * @param propertyName
   *            The name of the property
   * @return The field is any
   */
  Optional<ObjectFieldType> getFieldByName(String propertyName);

}
