/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import static java.util.Optional.ofNullable;

import org.mule.metadata.api.utils.MetadataTypeUtils;

import java.util.Objects;
import java.util.Optional;

/**
 * Applies a length range constrain of the annotated type. It can be applied to
 * string , array or object.
 */
public class LengthAnnotation implements TypeAnnotation {

  public static final String NAME = "length";
  private final Number min;
  private final Number max;

  public LengthAnnotation(Number min, Number max) {
    this.min = min;
    this.max = max;
  }

  public Optional<? extends Number> getMin() {
    return ofNullable(min);
  }

  public Optional<? extends Number> getMax() {
    return ofNullable(max);
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof LengthAnnotation) {
      LengthAnnotation other = (LengthAnnotation) obj;
      return Objects.equals(getMin(), other.getMin()) && Objects.equals(getMax(), other.getMax());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return MetadataTypeUtils.hashCode(getMin(), getMax());
  }
}
