/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import java.util.HashMap;
import java.util.Map;

/**
 * Additional metadata format properties. For example in csv it can be the separator
 */
public class MetadataFormatPropertiesAnnotation implements TypeAnnotation {

  public static final String NAME = "formatProperties";

  private Map<String, String> properties;

  public MetadataFormatPropertiesAnnotation(Map<String, String> properties) {
    this.properties = new HashMap<>(properties);
  }

  public Map<String, String> getValue() {
    return properties;
  }

  @Override
  public String getName() {
    return NAME;
  }
}
