/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;

/**
 * Represents an string example of the annotated type.
 */
public class ExampleAnnotation implements TypeAnnotation {

  public static final String NAME = "example";
  private final String value;

  public ExampleAnnotation(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof ExampleAnnotation) {
      return Objects.equals(value, ((ExampleAnnotation) obj).getValue());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return value.hashCode();
  }
}
