/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

/**
 * Represents an Object Key attribute.
 */
public interface AttributeFieldType extends MetadataType {

  /**
   * The key of the attribute.
   *
   * @return The attribute key.
   */
  AttributeKeyType getKey();

  /**
   * The value of the attribute
   *
   * @return The value
   */
  MetadataType getValue();

  /**
   * If this attribute is required or not.
   *
   * @return True if required.
   */
  boolean isRequired();
}
