/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.serialization;

import org.mule.metadata.api.annotation.TypeAnnotation;

/**
 * When serializing implementations of this interface, serializers should not serialize the instance but the output of the
 * serializationCopy() method, and such copy should not be used for anything else than that.
 *
 * @since 1.5.0
 */
public interface CustomCopySerialization {

  /**
   * @return a copy with the values to serialize.
   */
  TypeAnnotation serializationCopy();

}
