/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import java.util.List;

/**
 * For any types X and Y, the intersection, or conjunction, X&Y, of the types may be formed. Any type that is accepted by all the
 * subtypes defined in the intersection type is being accepted by this type
 */
public interface IntersectionType extends MetadataType {

  /**
   * The list of types
   *
   * @return The types
   */
  List<MetadataType> getTypes();
}
