/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;


import java.util.Arrays;

/**
 * Defines the list of labels for an enum.
 */
public class EnumLabelsAnnotation implements TypeAnnotation {

  public static final String NAME = "enumLabels";
  private final String[] labels;

  public EnumLabelsAnnotation(String[] labels) {
    this.labels = labels;
  }

  public String[] getLabels() {
    return labels;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof EnumLabelsAnnotation) {
      return Arrays.equals(labels, ((EnumLabelsAnnotation) obj).getLabels());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Arrays.hashCode(labels);
  }
}
