/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;

public class DateTimeBuilder extends AbstractBuilder<DateTimeType>
    implements TypeBuilder<DateTimeType>, WithAnnotation<DateTimeBuilder> {

  protected DateTimeBuilder(MetadataFormat format) {
    super(format);
  }

  public DateTimeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public DateTimeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }


  public DateTimeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  @Override
  public DateTimeType build() {
    return new DefaultDateTimeType(format, annotations);
  }
}
