/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Map;
import java.util.Optional;


public class DefaultStringType extends BaseMetadataType implements StringType {

  public DefaultStringType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
  }

  public Optional<String> getPattern() {
    return getAnnotation(RegexPatternAnnotation.class).map(pattern -> pattern.getValue());
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitString(this);
  }
}
