/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;


import java.util.Arrays;

/**
 * Defines the list of valid values for a given type.
 */
public class EnumAnnotation<T> implements TypeAnnotation {

  public static final String NAME = "enum";
  private final T[] values;

  public EnumAnnotation(T[] values) {
    this.values = values;
  }

  public T[] getValues() {
    return values;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof EnumAnnotation) {
      return Arrays.equals(values, ((EnumAnnotation) obj).getValues());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Arrays.hashCode(values);
  }
}
