/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.internal.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.Builder;
import org.mule.metadata.api.model.ReflectionAwareComparable;
import org.mule.metadata.internal.utils.IDKey;

public class EfficientReflectionHashCode
implements Builder<Integer> {
    private static final int DEFAULT_INITIAL_VALUE = 17;
    private static final int DEFAULT_MULTIPLIER_VALUE = 37;
    private static final ThreadLocal<Set<IDKey>> REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal = 17;

    static Set<IDKey> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object value) {
        Set<IDKey> registry = EfficientReflectionHashCode.getRegistry();
        return registry != null && registry.contains(new IDKey(value));
    }

    private static void reflectionAppend(Object object, EfficientReflectionHashCode builder) {
        if (EfficientReflectionHashCode.isRegistered(object)) {
            return;
        }
        try {
            EfficientReflectionHashCode.register(object);
            if (object instanceof ReflectionAwareComparable) {
                AccessibleObject[] fields = ((ReflectionAwareComparable)object).getReflectionComparableFields();
                AccessibleObject.setAccessible(fields, true);
                for (AccessibleObject field : fields) {
                    EfficientReflectionHashCode.reflectionAppend(((Field)field).get(object), builder);
                }
            } else if (object != null) {
                AccessibleObject[] fields = object.getClass().getDeclaredFields();
                Arrays.sort(fields, Comparator.comparing(Field::getName));
                AccessibleObject.setAccessible(fields, true);
                for (AccessibleObject field : fields) {
                    if (((Field)field).getName().contains("$") || Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                    Object fieldValue = ((Field)field).get(object);
                    builder.append(fieldValue);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error generating reflective hash code", e);
        }
        finally {
            EfficientReflectionHashCode.unregister(object);
        }
    }

    public static int reflectionHashCode(ReflectionAwareComparable object) {
        EfficientReflectionHashCode builder = new EfficientReflectionHashCode();
        EfficientReflectionHashCode.reflectionAppend(object, builder);
        return builder.build();
    }

    private static void register(Object value) {
        Set<IDKey> registry = EfficientReflectionHashCode.getRegistry();
        if (registry == null) {
            registry = new HashSet<IDKey>();
            REGISTRY.set(registry);
        }
        registry.add(new IDKey(value));
    }

    private static void unregister(Object value) {
        Set<IDKey> registry = EfficientReflectionHashCode.getRegistry();
        if (registry != null) {
            registry.remove(new IDKey(value));
            if (registry.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public EfficientReflectionHashCode() {
        this.iConstant = 37;
    }

    public EfficientReflectionHashCode append(boolean value) {
        this.iTotal = this.iTotal * this.iConstant + (value ? 0 : 1);
        return this;
    }

    private EfficientReflectionHashCode append(boolean[] array) {
        for (boolean element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(byte value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientReflectionHashCode append(byte[] array) {
        for (byte element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(char value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientReflectionHashCode append(char[] array) {
        for (char element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(double value) {
        return this.append(Double.doubleToLongBits(value));
    }

    private EfficientReflectionHashCode append(double[] array) {
        for (double element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(float value) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(value);
        return this;
    }

    private EfficientReflectionHashCode append(float[] array) {
        for (float element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(int value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientReflectionHashCode append(int[] array) {
        for (int element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(long value) {
        this.iTotal = this.iTotal * this.iConstant + (int)(value ^ value >> 32);
        return this;
    }

    private EfficientReflectionHashCode append(long[] array) {
        for (long element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
        } else if (object.getClass().isArray()) {
            this.appendArray(object);
        } else {
            this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        }
        return this;
    }

    private void appendArray(Object object) {
        if (object instanceof long[]) {
            this.append((long[])object);
        } else if (object instanceof int[]) {
            this.append((int[])object);
        } else if (object instanceof short[]) {
            this.append((short[])object);
        } else if (object instanceof char[]) {
            this.append((char[])object);
        } else if (object instanceof byte[]) {
            this.append((byte[])object);
        } else if (object instanceof double[]) {
            this.append((double[])object);
        } else if (object instanceof float[]) {
            this.append((float[])object);
        } else if (object instanceof boolean[]) {
            this.append((boolean[])object);
        } else {
            this.append((Object[])object);
        }
    }

    private EfficientReflectionHashCode append(Object[] array) {
        for (Object element : array) {
            this.append(element);
        }
        return this;
    }

    public EfficientReflectionHashCode append(short value) {
        this.iTotal = this.iTotal * this.iConstant + value;
        return this;
    }

    private EfficientReflectionHashCode append(short[] array) {
        for (short element : array) {
            this.append(element);
        }
        return this;
    }

    public Integer build() {
        return this.iTotal;
    }
}

