/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ReflectionAwareComparable;
import org.mule.metadata.internal.utils.EfficientReflectionEquals;
import org.mule.metadata.internal.utils.EfficientReflectionHashCode;

public abstract class BaseMetadataType
implements MetadataType,
ReflectionAwareComparable {
    protected final Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations;
    private final MetadataFormat metadataFormat;
    protected static final Field[] BASE_REFLECTION_FIELDS;
    private transient boolean hashCalculated;
    private transient int hash;

    public BaseMetadataType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        this.metadataFormat = metadataFormat;
        this.annotations = annotations == null ? null : Collections.unmodifiableMap(annotations);
    }

    @Override
    public Set<TypeAnnotation> getAnnotations() {
        return new LinkedHashSet<TypeAnnotation>(this.annotations.values());
    }

    @Override
    public MetadataFormat getMetadataFormat() {
        return this.metadataFormat;
    }

    @Override
    public <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> extension) {
        return Optional.ofNullable(this.annotations.get(extension));
    }

    @Override
    public Optional<String> getDescription() {
        return this.getAnnotation(DescriptionAnnotation.class).map(DescriptionAnnotation::getValue);
    }

    @Override
    public Field[] getReflectionComparableFields() {
        return BASE_REFLECTION_FIELDS;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return EfficientReflectionEquals.reflectionEquals(this, (BaseMetadataType)obj);
    }

    public int hashCode() {
        if (!this.hashCalculated) {
            this.hash = EfficientReflectionHashCode.reflectionHashCode(this);
            this.hashCalculated = true;
        }
        return this.hash;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    static {
        try {
            BASE_REFLECTION_FIELDS = new Field[]{BaseMetadataType.class.getDeclaredField("metadataFormat"), BaseMetadataType.class.getDeclaredField("annotations")};
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not resolve field", e);
        }
    }
}

