/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import org.mule.metadata.api.model.MetadataType;

/**
 * An annotation associated to a given type that can add additional information or specify a constraint.
 */
public interface TypeAnnotation {

  /**
   * A name of the annotation
   *
   * @return The name
   */
  String getName();

  /**
   * Returns whether this annotation is public or not. Public annotations are those which carry information which should be
   * consumed by third-parties, while non public ones are considered of exclusive use of the Mule runtime and thus should not be
   * advertised. For example, non public annotations are not persisted.
   * <p>
   * Non public annotations will however always be available through {@link MetadataType#getAnnotation(Class)} and all related
   * methods.
   *
   * @return Whether this annotation should be.
   */
  default boolean isPublic() {
    return true;
  }
}
