/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.EfficientReflectionHashCode;

public class DefaultUnionType
extends BaseMetadataType
implements UnionType {
    private final List<MetadataType> types;
    private static final Field[] REFLECTION_FIELDS;
    private transient boolean hashCalculated;
    private transient int hash;

    public DefaultUnionType(List<MetadataType> types, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.types = types;
    }

    @Override
    public Field[] getReflectionComparableFields() {
        return REFLECTION_FIELDS;
    }

    @Override
    public List<MetadataType> getTypes() {
        return this.types;
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitUnion(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.hashCalculated) {
            this.hash = EfficientReflectionHashCode.reflectionHashCode(this);
            for (MetadataType type : this.types) {
                this.hash = Objects.hash(this.hash, type);
            }
            this.hashCalculated = true;
        }
        return this.hash;
    }

    static {
        try {
            REFLECTION_FIELDS = (Field[])ArrayUtils.addAll((Object[])BASE_REFLECTION_FIELDS, (Object[])new Field[]{DefaultUnionType.class.getDeclaredField("types")});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not resolve field", e);
        }
    }
}

