/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

/**
 * Abstract specialization of {@link TypeAnnotation} for annotations which are stateless and their only purpose is to just serve
 * as markers.
 * <p>
 * The {@link #equals(Object)} and {@link #hashCode()} method are redefined to be based on the {@link #getName()} value.
 *
 * @since 1.0
 */
public abstract class MarkerAnnotation implements TypeAnnotation {

  @Override
  public boolean equals(Object obj) {
    if (getClass().isInstance(obj)) {
      return getName().equals(((TypeAnnotation) obj).getName());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return getName().hashCode();
  }
}
