/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;


import static org.apache.commons.lang3.ArrayUtils.addAll;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.lang.reflect.Field;
import java.util.Map;

public class DefaultTypeParameterType extends BaseMetadataType implements TypeParameterType {

  private final String name;

  public DefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                  Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.name = name;
  }

  private static final Field[] REFLECTION_FIELDS;
  static {
    try {
      REFLECTION_FIELDS = addAll(BASE_REFLECTION_FIELDS,
                                 DefaultTypeParameterType.class.getDeclaredField("name"));
    } catch (NoSuchFieldException e) {
      throw new RuntimeException("Could not resolve field", e);
    }
  }

  @Override
  public Field[] getReflectionComparableFields() {
    return REFLECTION_FIELDS;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitTypeParameter(this);
  }
}
