/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model;

import org.mule.metadata.internal.utils.EfficientEquals;
import org.mule.metadata.internal.utils.EfficientHashCode;

import java.lang.reflect.Field;

/**
 * Implementing this interface indicates that a class is ready to be called by {@link EfficientHashCode} or
 * {@link EfficientEquals} in order to generate it's hash code or check it's equality respectively.
 * <p>
 * The class implementing this interface must expose a set of {@link Field}s with its identity fields.
 *
 * @since 1.3
 */
public interface FieldsComparable {

  /**
   * A list of the fields that define the identity of this class. These fields can be used to compare if instances of a class are
   * equal, or to generate a hash code for it.
   * <p>
   * Have in mind not exposing fields of class {@link java.util.regex.Pattern}, for example, that only check for reference
   * equality (If that is not the desired behaviour).
   *
   */
  Object[] getFieldValues();
}
