/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static java.util.Collections.addAll;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class DefaultArrayType extends BaseMetadataType implements ArrayType {

  final private Supplier<MetadataType> type;

  // The only purpose of this field is to be compared on equals().
  private MetadataType typeValue;

  public DefaultArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat,
                          Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.type = type;
  }


  @Override
  public MetadataType getType() {
    return type.get();
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitArrayType(this);
  }

  @Override
  public Object[] getFieldValues() {
    // to keep the same behavior as before regarding the
    // supplier type, just in case the supplier behaves differently
    // in some project.
    // TODO: investigate if typeValue can be eagerly generated in DefaultArrayType (W-12731546)
    List<Object> fieldValues = new ArrayList<>();
    addAll(fieldValues, super.getFieldValues());
    addAll(fieldValues, typeValue);
    return fieldValues.toArray(new Object[fieldValues.size()]);
  }

  /**
   * Set the value of the {@link #typeValue} field.
   */
  private void setTypeValueForReflectionEqualsIfNull() {
    if (Objects.isNull(typeValue)) {
      typeValue = type.get();
    }
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null || getClass() != obj.getClass()) {
      return false;
    }

    // Workaround to ensure the typeValue field is defined on both objects, to be able to compare it using reflectionEquals.
    setTypeValueForReflectionEqualsIfNull();
    ((DefaultArrayType) obj).setTypeValueForReflectionEqualsIfNull();

    return super.equals(obj);
  }
}
