/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static java.util.Collections.addAll;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultAttributeFieldType extends BaseMetadataType implements AttributeFieldType {

  private final AttributeKeyType key;
  private final MetadataType value;
  private final boolean required;
  private Object[] fieldValues;

  public DefaultAttributeFieldType(AttributeKeyType key, MetadataType value, boolean required, MetadataFormat metadataFormat,
                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.key = key;
    this.value = value;
    this.required = required;
  }

  @Override
  public AttributeKeyType getKey() {
    return key;
  }

  @Override
  public MetadataType getValue() {
    return value;
  }

  @Override
  public boolean isRequired() {
    return required;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitAttributeField(this);
  }

  @Override
  public Object[] getFieldValues() {
    if (fieldValues == null) {
      fieldValues = createFieldValuesArray();
    }
    return fieldValues;
  }

  private Object[] createFieldValuesArray() {
    List<Object> fieldValues = new ArrayList<>();
    addAll(fieldValues, super.getFieldValues());
    addAll(fieldValues, key, value, required);
    return fieldValues.toArray(new Object[fieldValues.size()]);
  }
}
