/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import java.util.Objects;

/**
 * Used to specify the identifier in the underlying type system.
 */
public class TypeIdAnnotation implements TypeAnnotation {

  public static final String NAME = "typeId";
  private final String value;

  public TypeIdAnnotation(String className) {
    this.value = className;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof TypeIdAnnotation) {
      return Objects.equals(value, ((TypeIdAnnotation) obj).getValue());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return value.hashCode();
  }

  @Override
  public String toString() {
    return value;
  }
}
