/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import static java.util.Optional.ofNullable;

import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Objects;
import java.util.Optional;

/**
 * Constrain for minimum and maximum repetitions of a field.
 */
public class FieldOccurrenceAnnotation implements TypeAnnotation {

  public static final String NAME = "occurrence";
  private final Number min;
  private final Number max;

  public FieldOccurrenceAnnotation(Number min, Number max) {
    this.min = min;
    this.max = max;
  }

  public Optional<? extends Number> getMin() {
    return ofNullable(min);
  }

  public Optional<? extends Number> getMax() {
    return ofNullable(max);
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof FieldOccurrenceAnnotation) {
      FieldOccurrenceAnnotation other = (FieldOccurrenceAnnotation) obj;
      return Objects.equals(getMin(), other.getMin()) && Objects.equals(getMax(), other.getMax());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(max).append(min).build();
  }
}
