/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.impl.DefaultNothingType;

public class NothingTypeBuilder extends AbstractBuilder<NothingType>
    implements TypeBuilder<NothingType>, WithAnnotation<NothingTypeBuilder> {

  protected NothingTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public NothingTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public NothingTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  @Override
  public NothingType build() {
    return new DefaultNothingType(format, annotations);
  }

}
