/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.impl.DefaultPeriodType;

public class PeriodTypeBuilder extends AbstractBuilder<PeriodType>
    implements TypeBuilder<PeriodType>, WithAnnotation<PeriodTypeBuilder> {

  protected PeriodTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public PeriodTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public PeriodTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  @Override
  public PeriodType build() {
    return new DefaultPeriodType(format, annotations);
  }


}
